<?php

namespace App\Http\Controllers;

use App\Models\Inspection;
use Carbon\Carbon;

class WorkerController extends Controller
{
    public function dashboard()
    {
        $user = auth()->user();
        
        $stats = [
            'total_inspections' => Inspection::where('user_id', $user->id)->count(),
            'inspections_this_month' => Inspection::where('user_id', $user->id)
                ->whereMonth('inspection_date', Carbon::now()->month)
                ->count(),
            'passed_inspections' => Inspection::where('user_id', $user->id)
                ->where('overall_status', 'passed')
                ->count(),
            'failed_inspections' => Inspection::where('user_id', $user->id)
                ->where('overall_status', 'failed')
                ->count(),
        ];

        $recentInspections = Inspection::with(['equipment', 'checklist'])
            ->where('user_id', $user->id)
            ->orderBy('created_at', 'desc')
            ->limit(5)
            ->get();

        $assignedChecklists = $user->checklists()
            ->where('is_active', true)
            ->withCount('items')
            ->get();

        return view('worker.dashboard', compact('stats', 'recentInspections', 'assignedChecklists'));
    }
}
