<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Inspection extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'checklist_id',
        'equipment_id',
        'overall_status',
        'notes',
        'inspection_date',
    ];

    protected $casts = [
        'inspection_date' => 'datetime',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function checklist(): BelongsTo
    {
        return $this->belongsTo(Checklist::class);
    }

    public function equipment(): BelongsTo
    {
        return $this->belongsTo(Equipment::class);
    }

    public function items(): HasMany
    {
        return $this->hasMany(InspectionItem::class);
    }

    public function photos(): HasMany
    {
        return $this->hasMany(InspectionPhoto::class);
    }

    public function getStatusLabel(): string
    {
        return match($this->overall_status) {
            'passed' => 'Passed',
            'failed' => 'Failed',
            'partial' => 'Partial',
            default => 'Unknown',
        };
    }

    public function getStatusClass(): string
    {
        return match($this->overall_status) {
            'passed' => 'success',
            'failed' => 'danger',
            'partial' => 'warning',
            default => 'secondary',
        };
    }
}
