<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('inspections', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('checklist_id')->constrained('checklists')->onDelete('cascade');
            $table->foreignId('equipment_id')->constrained('equipment')->onDelete('cascade');
            $table->enum('overall_status', ['passed', 'failed', 'partial'])->default('passed');
            $table->text('notes')->nullable();
            $table->timestamp('inspection_date');
            $table->timestamps();
            
            $table->index(['equipment_id', 'inspection_date']);
            $table->index(['user_id', 'inspection_date']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('inspections');
    }
};
