@extends('layouts.app')

@section('title', 'Create Checklist')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-plus"></i> Create Checklist</h2>
    <a href="{{ route('admin.checklists.index') }}" class="btn btn-outline-secondary">
        <i class="bi bi-arrow-left"></i> Back
    </a>
</div>

<form action="{{ route('admin.checklists.store') }}" method="POST">
    @csrf

    <div class="row">
        <div class="col-md-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Checklist Details</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="title" class="form-label">Title</label>
                        <input type="text" class="form-control @error('title') is-invalid @enderror" 
                               id="title" name="title" value="{{ old('title') }}" required>
                        @error('title')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control @error('description') is-invalid @enderror" 
                                  id="description" name="description" rows="3">{{ old('description') }}</textarea>
                        @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="frequency_days" class="form-label">Frequency (days)</label>
                            <input type="number" class="form-control @error('frequency_days') is-invalid @enderror" 
                                   id="frequency_days" name="frequency_days" value="{{ old('frequency_days', 7) }}" 
                                   min="1" max="365" required>
                            @error('frequency_days')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3 d-flex align-items-end">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" id="is_active" name="is_active" value="1" 
                                       {{ old('is_active', true) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">Active</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Checklist Items</h5>
                    <button type="button" class="btn btn-sm btn-primary" onclick="addItem()">
                        <i class="bi bi-plus"></i> Add Item
                    </button>
                </div>
                <div class="card-body">
                    <div id="items-container">
                        <div class="item-row mb-3 p-3 border rounded">
                            <div class="row">
                                <div class="col-md-10">
                                    <input type="text" class="form-control mb-2" name="items[0][item_name]" 
                                           placeholder="Item name" required>
                                    <textarea class="form-control mb-2" name="items[0][description]" 
                                              placeholder="Description (optional)" rows="2"></textarea>
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" 
                                               name="items[0][require_description_on_fail]" value="1">
                                        <label class="form-check-label">Require description when failed</label>
                                    </div>
                                </div>
                                <div class="col-md-2 d-flex align-items-center">
                                    <button type="button" class="btn btn-outline-danger btn-sm" onclick="removeItem(this)">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Assign Equipment</h5>
                </div>
                <div class="card-body">
                    @foreach($equipment as $equip)
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" 
                                   name="equipment[]" value="{{ $equip->id }}" 
                                   id="equipment{{ $equip->id }}">
                            <label class="form-check-label" for="equipment{{ $equip->id }}">
                                {{ $equip->name }} ({{ $equip->tag_id }})
                            </label>
                        </div>
                    @endforeach
                </div>
            </div>

            <button type="submit" class="btn btn-primary w-100">
                <i class="bi bi-check"></i> Create Checklist
            </button>
        </div>
    </div>
</form>

@push('scripts')
<script>
let itemIndex = 1;

function addItem() {
    const container = document.getElementById('items-container');
    const html = `
        <div class="item-row mb-3 p-3 border rounded">
            <div class="row">
                <div class="col-md-10">
                    <input type="text" class="form-control mb-2" name="items[${itemIndex}][item_name]" 
                           placeholder="Item name" required>
                    <textarea class="form-control mb-2" name="items[${itemIndex}][description]" 
                              placeholder="Description (optional)" rows="2"></textarea>
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" 
                               name="items[${itemIndex}][require_description_on_fail]" value="1">
                        <label class="form-check-label">Require description when failed</label>
                    </div>
                </div>
                <div class="col-md-2 d-flex align-items-center">
                    <button type="button" class="btn btn-outline-danger btn-sm" onclick="removeItem(this)">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
            </div>
        </div>
    `;
    container.insertAdjacentHTML('beforeend', html);
    itemIndex++;
}

function removeItem(button) {
    const items = document.querySelectorAll('.item-row');
    if (items.length > 1) {
        button.closest('.item-row').remove();
    }
}
</script>
@endpush
@endsection
