@extends('layouts.app')

@section('title', 'Edit Equipment')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-pencil"></i> Edit Equipment</h2>
    <a href="{{ route('admin.equipment.index') }}" class="btn btn-outline-secondary">
        <i class="bi bi-arrow-left"></i> Back
    </a>
</div>

<div class="card">
    <div class="card-body">
        <form action="{{ route('admin.equipment.update', $equipment) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="name" class="form-label">Equipment Name</label>
                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                           id="name" name="name" value="{{ old('name', $equipment->name) }}" required>
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 mb-3">
                    <label for="tag_id" class="form-label">Tag ID</label>
                    <input type="text" class="form-control @error('tag_id') is-invalid @enderror" 
                           id="tag_id" name="tag_id" value="{{ old('tag_id', $equipment->tag_id) }}" required>
                    @error('tag_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="department_id" class="form-label">Department</label>
                    <select class="form-select @error('department_id') is-invalid @enderror" 
                            id="department_id" name="department_id" required>
                        @foreach($departments as $department)
                            <option value="{{ $department->id }}" 
                                {{ old('department_id', $equipment->department_id) == $department->id ? 'selected' : '' }}>
                                {{ $department->name }}
                            </option>
                        @endforeach
                    </select>
                    @error('department_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 mb-3">
                    <label for="location" class="form-label">Location</label>
                    <input type="text" class="form-control @error('location') is-invalid @enderror" 
                           id="location" name="location" value="{{ old('location', $equipment->location) }}" required>
                    @error('location')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="type" class="form-label">Type</label>
                    <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                        <option value="tool" {{ old('type', $equipment->type) === 'tool' ? 'selected' : '' }}>Tool</option>
                        <option value="forklift" {{ old('type', $equipment->type) === 'forklift' ? 'selected' : '' }}>Forklift</option>
                        <option value="crane" {{ old('type', $equipment->type) === 'crane' ? 'selected' : '' }}>Crane</option>
                        <option value="vehicle" {{ old('type', $equipment->type) === 'vehicle' ? 'selected' : '' }}>Vehicle</option>
                        <option value="machinery" {{ old('type', $equipment->type) === 'machinery' ? 'selected' : '' }}>Machinery</option>
                        <option value="other" {{ old('type', $equipment->type) === 'other' ? 'selected' : '' }}>Other</option>
                    </select>
                    @error('type')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 mb-3 d-flex align-items-end">
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" id="is_active" name="is_active" value="1" 
                               {{ old('is_active', $equipment->is_active) ? 'checked' : '' }}>
                        <label class="form-check-label" for="is_active">Active</label>
                    </div>
                </div>
            </div>

            <div class="mb-3">
                <label for="description" class="form-label">Description</label>
                <textarea class="form-control @error('description') is-invalid @enderror" 
                          id="description" name="description" rows="3">{{ old('description', $equipment->description) }}</textarea>
                @error('description')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="mb-3">
                <label class="form-label">Assign to Checklists</label>
                <div class="row">
                    @foreach($checklists as $checklist)
                        <div class="col-md-4">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" 
                                       name="checklists[]" value="{{ $checklist->id }}" 
                                       id="checklist{{ $checklist->id }}"
                                       {{ in_array($checklist->id, old('checklists', $selectedChecklists)) ? 'checked' : '' }}>
                                <label class="form-check-label" for="checklist{{ $checklist->id }}">
                                    {{ $checklist->title }}
                                </label>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <button type="submit" class="btn btn-primary">
                <i class="bi bi-check"></i> Update Equipment
            </button>
        </form>
    </div>
</div>
@endsection
