@extends('layouts.app')

@section('title', 'Inspections')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-file-earmark-text"></i> Inspections</h2>
    <a href="{{ route('admin.inspections.export', request()->query()) }}" class="btn btn-outline-primary">
        <i class="bi bi-download"></i> Export CSV
    </a>
</div>

<div class="card mb-4">
    <div class="card-body">
        <form action="" method="GET" class="row g-3">
            <div class="col-md-2">
                <label class="form-label">From Date</label>
                <input type="date" class="form-control" name="date_from" value="{{ request('date_from') }}">
            </div>
            <div class="col-md-2">
                <label class="form-label">To Date</label>
                <input type="date" class="form-control" name="date_to" value="{{ request('date_to') }}">
            </div>
            <div class="col-md-3">
                <label class="form-label">Worker</label>
                <select class="form-select" name="user_id">
                    <option value="">All Workers</option>
                    @foreach($users as $user)
                        <option value="{{ $user->id }}" {{ request('user_id') == $user->id ? 'selected' : '' }}>
                            {{ $user->full_name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Equipment</label>
                <select class="form-select" name="equipment_id">
                    <option value="">All Equipment</option>
                    @foreach($equipment as $equip)
                        <option value="{{ $equip->id }}" {{ request('equipment_id') == $equip->id ? 'selected' : '' }}>
                            {{ $equip->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Status</label>
                <select class="form-select" name="status">
                    <option value="">All</option>
                    <option value="passed" {{ request('status') === 'passed' ? 'selected' : '' }}>Passed</option>
                    <option value="failed" {{ request('status') === 'failed' ? 'selected' : '' }}>Failed</option>
                </select>
            </div>
            <div class="col-12">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-search"></i> Filter
                </button>
                <a href="{{ route('admin.inspections.index') }}" class="btn btn-outline-secondary">Clear</a>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Date</th>
                        <th>Worker</th>
                        <th>Equipment</th>
                        <th>Checklist</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($inspections as $inspection)
                        <tr>
                            <td>#{{ $inspection->id }}</td>
                            <td>{{ $inspection->inspection_date->format('M d, Y H:i') }}</td>
                            <td>{{ $inspection->user->full_name }}</td>
                            <td>{{ $inspection->equipment->name }}</td>
                            <td>{{ $inspection->checklist->title }}</td>
                            <td>
                                <span class="badge bg-{{ $inspection->getStatusClass() }}">
                                    {{ $inspection->getStatusLabel() }}
                                </span>
                            </td>
                            <td>
                                <a href="{{ route('admin.inspections.show', $inspection) }}" class="btn btn-sm btn-outline-info">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <a href="{{ route('inspections.print', $inspection) }}" class="btn btn-sm btn-outline-secondary" target="_blank">
                                    <i class="bi bi-printer"></i>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        {{ $inspections->appends(request()->query())->links() }}
    </div>
</div>
@endsection
