<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inspection Report #{{ $inspection->id }}</title>
    <style>
        * {
            box-sizing: border-box;
        }
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            font-size: 12px;
            line-height: 1.4;
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        .header h1 {
            margin: 0 0 5px 0;
            font-size: 24px;
        }
        .header p {
            margin: 0;
            color: #666;
        }
        .info-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 20px;
        }
        .info-section {
            border: 1px solid #ddd;
            padding: 15px;
        }
        .info-section h3 {
            margin: 0 0 10px 0;
            padding-bottom: 5px;
            border-bottom: 1px solid #ddd;
            font-size: 14px;
        }
        .info-row {
            margin-bottom: 5px;
        }
        .info-row strong {
            display: inline-block;
            width: 100px;
        }
        .status {
            display: inline-block;
            padding: 3px 10px;
            font-weight: bold;
            border-radius: 3px;
        }
        .status.passed {
            background: #d4edda;
            color: #155724;
        }
        .status.failed {
            background: #f8d7da;
            color: #721c24;
        }
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .items-table th,
        .items-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .items-table th {
            background: #f4f4f4;
            font-weight: bold;
        }
        .result-ok {
            color: #155724;
            font-weight: bold;
        }
        .result-fail {
            color: #721c24;
            font-weight: bold;
        }
        .result-na {
            color: #666;
        }
        .notes-section {
            border: 1px solid #ddd;
            padding: 15px;
            margin-bottom: 20px;
        }
        .photos-section {
            margin-bottom: 20px;
        }
        .photos-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
        }
        .photos-grid img {
            width: 100%;
            height: auto;
            border: 1px solid #ddd;
        }
        .footer {
            text-align: center;
            border-top: 1px solid #ddd;
            padding-top: 15px;
            margin-top: 20px;
            color: #666;
            font-size: 10px;
        }
        .signature-section {
            margin-top: 40px;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 40px;
        }
        .signature-line {
            border-top: 1px solid #333;
            padding-top: 5px;
            margin-top: 40px;
        }
        @media print {
            body {
                padding: 0;
            }
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="no-print" style="margin-bottom: 20px;">
        <button onclick="window.print()" style="padding: 10px 20px; cursor: pointer;">
            Print Report
        </button>
        <button onclick="window.close()" style="padding: 10px 20px; cursor: pointer; margin-left: 10px;">
            Close
        </button>
    </div>

    <div class="header">
        <h1>EQUIPMENT INSPECTION REPORT</h1>
        <p>Report #{{ $inspection->id }} | Generated: {{ now()->format('M d, Y H:i:s') }}</p>
    </div>

    <div class="info-grid">
        <div class="info-section">
            <h3>Worker Information</h3>
            <div class="info-row"><strong>Full Name:</strong> {{ $inspection->user->full_name }}</div>
            <div class="info-row"><strong>Username:</strong> {{ $inspection->user->username }}</div>
            <div class="info-row"><strong>Employee ID:</strong> {{ $inspection->user->employee_id }}</div>
            <div class="info-row"><strong>Department:</strong> {{ $inspection->user->department->name }}</div>
        </div>

        <div class="info-section">
            <h3>Equipment Information</h3>
            <div class="info-row"><strong>Name:</strong> {{ $inspection->equipment->name }}</div>
            <div class="info-row"><strong>Tag ID:</strong> {{ $inspection->equipment->tag_id }}</div>
            <div class="info-row"><strong>Location:</strong> {{ $inspection->equipment->location }}</div>
            <div class="info-row"><strong>Type:</strong> {{ $inspection->equipment->getTypeLabel() }}</div>
            <div class="info-row"><strong>Department:</strong> {{ $inspection->equipment->department->name }}</div>
        </div>
    </div>

    <div class="info-grid">
        <div class="info-section">
            <h3>Inspection Details</h3>
            <div class="info-row"><strong>Checklist:</strong> {{ $inspection->checklist->title }}</div>
            <div class="info-row"><strong>Date/Time:</strong> {{ $inspection->inspection_date->format('M d, Y H:i:s') }}</div>
            <div class="info-row">
                <strong>Status:</strong> 
                <span class="status {{ $inspection->overall_status }}">
                    {{ strtoupper($inspection->overall_status) }}
                </span>
            </div>
        </div>
    </div>

    <h3>Inspection Items</h3>
    <table class="items-table">
        <thead>
            <tr>
                <th style="width: 5%;">#</th>
                <th style="width: 35%;">Item</th>
                <th style="width: 15%;">Result</th>
                <th style="width: 45%;">Description/Notes</th>
            </tr>
        </thead>
        <tbody>
            @foreach($inspection->items as $index => $item)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $item->checklistItem->item_name }}</td>
                    <td>
                        <span class="result-{{ $item->result }}">
                            {{ $item->getResultLabel() }}
                        </span>
                    </td>
                    <td>{{ $item->fail_description ?: '-' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    @if($inspection->notes)
        <div class="notes-section">
            <h3>Additional Notes</h3>
            <p>{{ $inspection->notes }}</p>
        </div>
    @endif

    @if($inspection->photos->isNotEmpty())
        <div class="photos-section">
            <h3>Attached Photos</h3>
            <div class="photos-grid">
                @foreach($inspection->photos as $photo)
                    <img src="{{ Storage::url($photo->path) }}" alt="{{ $photo->original_name }}">
                @endforeach
            </div>
        </div>
    @endif

    <div class="signature-section">
        <div>
            <div class="signature-line">Inspector Signature</div>
        </div>
        <div>
            <div class="signature-line">Supervisor Signature</div>
        </div>
    </div>

    <div class="footer">
        <p>This report was automatically generated by the Inspection System.</p>
        <p>Report ID: {{ $inspection->id }} | Generated: {{ now()->format('Y-m-d H:i:s') }}</p>
    </div>
</body>
</html>
