@extends('layouts.app')

@section('title', 'Select Checklist')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-list-check"></i> Select Checklist</h2>
</div>

@if($checklists->isEmpty())
    <div class="card">
        <div class="card-body text-center py-5">
            <i class="bi bi-exclamation-circle" style="font-size: 3rem; color: #ccc;"></i>
            <h4 class="mt-3">No Checklists Assigned</h4>
            <p class="text-muted">Please contact your administrator to assign checklists to your account.</p>
        </div>
    </div>
@else
    <div class="row g-4">
        @foreach($checklists as $checklist)
            <div class="col-md-4">
                <div class="card h-100">
                    <div class="card-body">
                        <h5 class="card-title">{{ $checklist->title }}</h5>
                        <p class="card-text text-muted">{{ Str::limit($checklist->description, 100) ?: 'No description' }}</p>
                        <p class="mb-0">
                            <span class="badge bg-secondary">{{ $checklist->items_count }} items</span>
                            <span class="badge bg-info">Every {{ $checklist->frequency_days }} days</span>
                        </p>
                    </div>
                    <div class="card-footer bg-transparent">
                        <a href="{{ route('worker.inspections.select-equipment', $checklist) }}" class="btn btn-primary w-100">
                            Select Equipment <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@endif
@endsection
