@extends('layouts.app')

@section('title', 'Select Equipment')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-tools"></i> Select Equipment</h2>
    <a href="{{ route('worker.inspections.select-checklist') }}" class="btn btn-outline-secondary">
        <i class="bi bi-arrow-left"></i> Back
    </a>
</div>

<div class="alert alert-info">
    <strong>Checklist:</strong> {{ $checklist->title }}
    @if($checklist->description)
        <br><small>{{ $checklist->description }}</small>
    @endif
</div>

@if($equipment->isEmpty())
    <div class="card">
        <div class="card-body text-center py-5">
            <i class="bi bi-exclamation-circle" style="font-size: 3rem; color: #ccc;"></i>
            <h4 class="mt-3">No Equipment Available</h4>
            <p class="text-muted">No equipment is linked to this checklist.</p>
        </div>
    </div>
@else
    <div class="row g-4">
        @foreach($equipment as $equip)
            @php
                $recentlyInspected = isset($inspectedRecently[$equip->id]);
            @endphp
            <div class="col-md-4">
                <div class="card h-100 {{ $recentlyInspected ? 'border-warning' : '' }}">
                    <div class="card-body">
                        <h5 class="card-title">{{ $equip->name }}</h5>
                        <p class="mb-1"><strong>Tag ID:</strong> <code>{{ $equip->tag_id }}</code></p>
                        <p class="mb-1"><strong>Location:</strong> {{ $equip->location }}</p>
                        <p class="mb-1"><strong>Type:</strong> {{ $equip->getTypeLabel() }}</p>
                        <p class="mb-0"><strong>Department:</strong> {{ $equip->department->name }}</p>

                        @if($recentlyInspected)
                            <div class="alert alert-warning mt-3 mb-0 py-2">
                                <small>
                                    <i class="bi bi-clock"></i> 
                                    Inspected on {{ $inspectedRecently[$equip->id]['last_inspection']->inspection_date->format('M d') }}.
                                    Wait {{ $inspectedRecently[$equip->id]['days_remaining'] }} more day(s).
                                </small>
                            </div>
                        @endif
                    </div>
                    <div class="card-footer bg-transparent">
                        @if($recentlyInspected)
                            <button class="btn btn-secondary w-100" disabled>
                                <i class="bi bi-clock"></i> Recently Inspected
                            </button>
                        @else
                            <a href="{{ route('worker.inspections.create', [$checklist, $equip]) }}" class="btn btn-primary w-100">
                                Start Inspection <i class="bi bi-arrow-right"></i>
                            </a>
                        @endif
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@endif
@endsection
