<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Checklist extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
        'frequency_days',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'frequency_days' => 'integer',
    ];

    public function items(): HasMany
    {
        return $this->hasMany(ChecklistItem::class)->orderBy('sort_order');
    }

    public function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class, 'user_checklists')
            ->withTimestamps();
    }

    public function equipment(): BelongsToMany
    {
        return $this->belongsToMany(Equipment::class, 'checklist_equipment')
            ->withTimestamps();
    }

    public function inspections(): HasMany
    {
        return $this->hasMany(Inspection::class);
    }
}
