@extends('layouts.app')

@section('title', 'Edit Checklist')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-pencil"></i> Edit Checklist</h2>
    <a href="{{ route('admin.checklists.index') }}" class="btn btn-outline-secondary">
        <i class="bi bi-arrow-left"></i> Back
    </a>
</div>

<form action="{{ route('admin.checklists.update', $checklist) }}" method="POST">
    @csrf
    @method('PUT')

    <div class="row">
        <div class="col-md-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Checklist Details</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="title" class="form-label">Title</label>
                        <input type="text" class="form-control @error('title') is-invalid @enderror" 
                               id="title" name="title" value="{{ old('title', $checklist->title) }}" required>
                        @error('title')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control @error('description') is-invalid @enderror" 
                                  id="description" name="description" rows="3">{{ old('description', $checklist->description) }}</textarea>
                        @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="frequency_days" class="form-label">Frequency (days)</label>
                            <input type="number" class="form-control @error('frequency_days') is-invalid @enderror" 
                                   id="frequency_days" name="frequency_days" 
                                   value="{{ old('frequency_days', $checklist->frequency_days) }}" 
                                   min="1" max="365" required>
                            @error('frequency_days')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3 d-flex align-items-end">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" id="is_active" name="is_active" value="1" 
                                       {{ old('is_active', $checklist->is_active) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">Active</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Assign Equipment</h5>
                </div>
                <div class="card-body">
                    @foreach($equipment as $equip)
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" 
                                   name="equipment[]" value="{{ $equip->id }}" 
                                   id="equipment{{ $equip->id }}"
                                   {{ in_array($equip->id, old('equipment', $selectedEquipment)) ? 'checked' : '' }}>
                            <label class="form-check-label" for="equipment{{ $equip->id }}">
                                {{ $equip->name }} ({{ $equip->tag_id }})
                            </label>
                        </div>
                    @endforeach
                </div>
            </div>

            <button type="submit" class="btn btn-primary w-100">
                <i class="bi bi-check"></i> Update Checklist
            </button>
        </div>
    </div>
</form>
@endsection
