@extends('layouts.app')

@section('title', 'Inspection #' . $inspection->id)

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-file-earmark-text"></i> Inspection #{{ $inspection->id }}</h2>
    <div>
        <a href="{{ route('inspections.print', $inspection) }}" class="btn btn-outline-secondary" target="_blank">
            <i class="bi bi-printer"></i> Print Report
        </a>
        <a href="{{ route('admin.inspections.index') }}" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Back
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Inspection Items</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Item</th>
                                <th>Result</th>
                                <th>Notes</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($inspection->items as $item)
                                <tr>
                                    <td>{{ $item->checklistItem->item_name }}</td>
                                    <td>
                                        <span class="badge bg-{{ $item->getResultClass() }}">
                                            {{ $item->getResultLabel() }}
                                        </span>
                                    </td>
                                    <td>{{ $item->fail_description ?: '-' }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        @if($inspection->photos->isNotEmpty())
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Photos</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        @foreach($inspection->photos as $photo)
                            <div class="col-md-4">
                                <a href="{{ Storage::url($photo->path) }}" target="_blank">
                                    <img src="{{ Storage::url($photo->path) }}" class="img-fluid rounded" 
                                         alt="{{ $photo->original_name }}">
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif

        @if($inspection->notes)
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Notes</h5>
                </div>
                <div class="card-body">
                    {{ $inspection->notes }}
                </div>
            </div>
        @endif
    </div>

    <div class="col-md-4">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Inspection Details</h5>
            </div>
            <div class="card-body">
                <p><strong>Date:</strong><br>{{ $inspection->inspection_date->format('M d, Y H:i:s') }}</p>
                <p><strong>Status:</strong><br>
                    <span class="badge bg-{{ $inspection->getStatusClass() }} badge-status">
                        {{ $inspection->getStatusLabel() }}
                    </span>
                </p>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Worker Information</h5>
            </div>
            <div class="card-body">
                <p><strong>Name:</strong><br>{{ $inspection->user->full_name }}</p>
                <p><strong>Username:</strong><br>{{ $inspection->user->username }}</p>
                <p><strong>Employee ID:</strong><br>{{ $inspection->user->employee_id }}</p>
                <p><strong>Department:</strong><br>{{ $inspection->user->department->name }}</p>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Equipment Information</h5>
            </div>
            <div class="card-body">
                <p><strong>Name:</strong><br>{{ $inspection->equipment->name }}</p>
                <p><strong>Tag ID:</strong><br><code>{{ $inspection->equipment->tag_id }}</code></p>
                <p><strong>Location:</strong><br>{{ $inspection->equipment->location }}</p>
                <p><strong>Type:</strong><br>{{ $inspection->equipment->getTypeLabel() }}</p>
                <p><strong>Department:</strong><br>{{ $inspection->equipment->department->name }}</p>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Checklist</h5>
            </div>
            <div class="card-body">
                <p><strong>Title:</strong><br>{{ $inspection->checklist->title }}</p>
                <p><strong>Description:</strong><br>{{ $inspection->checklist->description ?: 'N/A' }}</p>
            </div>
        </div>
    </div>
</div>
@endsection
