<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ChecklistController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\EquipmentController;
use App\Http\Controllers\InspectionController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\WorkerController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    if (auth()->check()) {
        return auth()->user()->isAdmin() 
            ? redirect()->route('admin.dashboard')
            : redirect()->route('worker.dashboard');
    }
    return redirect()->route('login');
});

Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::get('/register', [AuthController::class, 'showRegister'])->name('register');
Route::post('/register', [AuthController::class, 'register']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

Route::middleware(['auth', 'approved'])->group(function () {
    Route::get('/inspection/{inspection}/print', [InspectionController::class, 'printReport'])
        ->name('inspections.print');

    Route::prefix('admin')->name('admin.')->middleware('admin')->group(function () {
        Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');

        Route::get('/users', [AdminController::class, 'users'])->name('users.index');
        Route::get('/users/pending', [AdminController::class, 'pendingUsers'])->name('users.pending');
        Route::post('/users/{user}/approve', [AdminController::class, 'approveUser'])->name('users.approve');
        Route::post('/users/{user}/reject', [AdminController::class, 'rejectUser'])->name('users.reject');
        Route::get('/users/{user}/edit', [AdminController::class, 'editUser'])->name('users.edit');
        Route::put('/users/{user}', [AdminController::class, 'updateUser'])->name('users.update');
        Route::delete('/users/{user}', [AdminController::class, 'deleteUser'])->name('users.delete');

        Route::resource('departments', DepartmentController::class);

        Route::resource('checklists', ChecklistController::class);
        Route::post('/checklists/{checklist}/items', [ChecklistController::class, 'storeItem'])
            ->name('checklists.items.store');
        Route::put('/checklist-items/{item}', [ChecklistController::class, 'updateItem'])
            ->name('checklists.items.update');
        Route::delete('/checklist-items/{item}', [ChecklistController::class, 'destroyItem'])
            ->name('checklists.items.destroy');

        Route::resource('equipment', EquipmentController::class);

        Route::get('/inspections', [InspectionController::class, 'adminIndex'])->name('inspections.index');
        Route::get('/inspections/export', [InspectionController::class, 'export'])->name('inspections.export');
        Route::get('/inspections/{inspection}', [InspectionController::class, 'adminShow'])->name('inspections.show');

        Route::get('/settings', [SettingsController::class, 'index'])->name('settings.index');
        Route::post('/settings', [SettingsController::class, 'update'])->name('settings.update');
    });

    Route::prefix('worker')->name('worker.')->group(function () {
        Route::get('/dashboard', [WorkerController::class, 'dashboard'])->name('dashboard');

        Route::get('/inspections', [InspectionController::class, 'workerIndex'])->name('inspections.index');
        Route::get('/inspections/new', [InspectionController::class, 'selectChecklist'])->name('inspections.select-checklist');
        Route::get('/inspections/new/{checklist}', [InspectionController::class, 'selectEquipment'])
            ->name('inspections.select-equipment');
        Route::get('/inspections/new/{checklist}/{equipment}', [InspectionController::class, 'create'])
            ->name('inspections.create');
        Route::post('/inspections/new/{checklist}/{equipment}', [InspectionController::class, 'store'])
            ->name('inspections.store');
        Route::get('/inspections/{inspection}', [InspectionController::class, 'workerShow'])
            ->name('inspections.show');
    });
});
