# Inspection System - Installation Guide

## Requirements
- PHP 8.2+
- PostgreSQL 12+
- Composer
- Git (optional)

## Quick Installation Steps

### 1. Download & Extract
```bash
# Extract the inspection-system.tar.gz file to your desired location
tar -xzf inspection-system.tar.gz
cd inspection-system
```

### 2. Install Dependencies
```bash
composer install
```

### 3. Setup Environment
```bash
cp .env.example .env
php artisan key:generate
```

### 4. Configure Database
Edit `.env` file with your database credentials:
```
DB_CONNECTION=pgsql
DB_HOST=your_database_host
DB_PORT=5432
DB_DATABASE=your_database_name
DB_USERNAME=your_database_user
DB_PASSWORD=your_database_password
```

### 5. Run Migrations
```bash
php artisan migrate
php artisan db:seed
```

### 6. Create Storage Link
```bash
php artisan storage:link
```

### 7. Start Server
```bash
# Development
php artisan serve

# Production (using nginx/apache)
# Configure your web server to point to /public directory
```

## Default Admin Credentials
- **Username:** admin
- **Password:** admin123

## Production Deployment

### Using Apache/Nginx:
1. Point document root to `/public` directory
2. Ensure `.env` has correct database credentials
3. Set `APP_ENV=production` in `.env`
4. Run `php artisan config:cache`

### Important Files to Edit:
- `.env` - Database and app configuration
- `config/mail.php` - Email settings (for notifications)
- `admin/settings` - Safety Manager email for inspection notifications

## Features
✓ User authentication with admin approval
✓ Admin dashboard with statistics
✓ Checklist and equipment management
✓ Worker inspection workflow
✓ Photo uploads
✓ Printable reports
✓ CSV/HTML export
✓ Email notifications

## Troubleshooting

**Database connection error:**
- Check `.env` database credentials
- Verify PostgreSQL is running
- Test database connection

**Permission error:**
- Ensure `storage/` and `bootstrap/cache/` are writable
- Run: `chmod -R 755 storage bootstrap/cache`

**Session errors:**
- If using file sessions, ensure `storage/framework/sessions/` is writable
- Current config uses cookies (no sessions folder needed)

## Support
All features are working. If you need help, check Laravel documentation at https://laravel.com
