<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ChecklistItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'checklist_id',
        'item_name',
        'description',
        'require_description_on_fail',
        'sort_order',
        'is_active',
    ];

    protected $casts = [
        'require_description_on_fail' => 'boolean',
        'is_active' => 'boolean',
        'sort_order' => 'integer',
    ];

    public function checklist(): BelongsTo
    {
        return $this->belongsTo(Checklist::class);
    }

    public function inspectionItems(): HasMany
    {
        return $this->hasMany(InspectionItem::class);
    }
}
