<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('equipment', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('tag_id')->unique();
            $table->foreignId('department_id')->constrained('departments')->onDelete('cascade');
            $table->string('location');
            $table->enum('type', ['tool', 'forklift', 'crane', 'vehicle', 'machinery', 'other'])->default('other');
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('equipment');
    }
};
