<?php

namespace Database\Seeders;

use App\Models\Checklist;
use App\Models\ChecklistItem;
use App\Models\Department;
use App\Models\Equipment;
use App\Models\Setting;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        $departments = [
            ['name' => 'Operations', 'description' => 'Main operations department'],
            ['name' => 'Maintenance', 'description' => 'Equipment maintenance team'],
            ['name' => 'Warehouse', 'description' => 'Warehouse and logistics'],
            ['name' => 'Safety', 'description' => 'Safety and compliance'],
        ];

        foreach ($departments as $dept) {
            Department::create($dept);
        }

        $admin = User::create([
            'full_name' => 'System Administrator',
            'username' => 'admin',
            'employee_id' => 'EMP001',
            'department_id' => 1,
            'email' => 'admin@example.com',
            'password' => Hash::make('admin123'),
            'role' => 'admin',
            'status' => 'approved',
        ]);

        $forkliftChecklist = Checklist::create([
            'title' => 'Forklift Daily Inspection',
            'description' => 'Daily safety inspection for forklifts before operation',
            'frequency_days' => 1,
            'is_active' => true,
        ]);

        $forkliftItems = [
            ['item_name' => 'Check tire condition and inflation', 'require_description_on_fail' => true],
            ['item_name' => 'Inspect forks for cracks or damage', 'require_description_on_fail' => true],
            ['item_name' => 'Test horn and warning lights', 'require_description_on_fail' => false],
            ['item_name' => 'Check hydraulic fluid level', 'require_description_on_fail' => true],
            ['item_name' => 'Verify brake operation', 'require_description_on_fail' => true],
            ['item_name' => 'Check seat belt functionality', 'require_description_on_fail' => true],
            ['item_name' => 'Inspect overhead guard', 'require_description_on_fail' => true],
            ['item_name' => 'Test steering response', 'require_description_on_fail' => true],
        ];

        foreach ($forkliftItems as $index => $item) {
            ChecklistItem::create([
                'checklist_id' => $forkliftChecklist->id,
                'item_name' => $item['item_name'],
                'require_description_on_fail' => $item['require_description_on_fail'],
                'sort_order' => $index,
            ]);
        }

        $craneChecklist = Checklist::create([
            'title' => 'Crane Weekly Inspection',
            'description' => 'Weekly safety inspection for overhead cranes',
            'frequency_days' => 7,
            'is_active' => true,
        ]);

        $craneItems = [
            ['item_name' => 'Inspect wire rope for wear or damage', 'require_description_on_fail' => true],
            ['item_name' => 'Check hook for cracks or deformation', 'require_description_on_fail' => true],
            ['item_name' => 'Test limit switches', 'require_description_on_fail' => true],
            ['item_name' => 'Verify emergency stop function', 'require_description_on_fail' => true],
            ['item_name' => 'Check pendant control operation', 'require_description_on_fail' => true],
            ['item_name' => 'Inspect runway and bridge rails', 'require_description_on_fail' => true],
        ];

        foreach ($craneItems as $index => $item) {
            ChecklistItem::create([
                'checklist_id' => $craneChecklist->id,
                'item_name' => $item['item_name'],
                'require_description_on_fail' => $item['require_description_on_fail'],
                'sort_order' => $index,
            ]);
        }

        $forklift1 = Equipment::create([
            'name' => 'Forklift FL-001',
            'tag_id' => 'FL-001',
            'department_id' => 3,
            'location' => 'Warehouse A - Loading Dock',
            'type' => 'forklift',
            'is_active' => true,
        ]);

        $forklift2 = Equipment::create([
            'name' => 'Forklift FL-002',
            'tag_id' => 'FL-002',
            'department_id' => 3,
            'location' => 'Warehouse B - Storage Area',
            'type' => 'forklift',
            'is_active' => true,
        ]);

        $crane1 = Equipment::create([
            'name' => 'Overhead Crane CR-001',
            'tag_id' => 'CR-001',
            'department_id' => 1,
            'location' => 'Manufacturing Bay 1',
            'type' => 'crane',
            'is_active' => true,
        ]);

        $forkliftChecklist->equipment()->attach([$forklift1->id, $forklift2->id]);
        $craneChecklist->equipment()->attach([$crane1->id]);

        Setting::set('company_name', 'Inspection System');
        Setting::set('safety_manager_email', '');
    }
}
