@extends('layouts.app')

@section('title', 'Checklists')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-list-check"></i> Checklists</h2>
    <a href="{{ route('admin.checklists.create') }}" class="btn btn-primary">
        <i class="bi bi-plus"></i> Create Checklist
    </a>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Title</th>
                        <th>Items</th>
                        <th>Equipment</th>
                        <th>Users</th>
                        <th>Frequency</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($checklists as $checklist)
                        <tr>
                            <td>{{ $checklist->title }}</td>
                            <td>{{ $checklist->items_count }}</td>
                            <td>{{ $checklist->equipment_count }}</td>
                            <td>{{ $checklist->users_count }}</td>
                            <td>{{ $checklist->frequency_days }} days</td>
                            <td>
                                <span class="badge {{ $checklist->is_active ? 'bg-success' : 'bg-secondary' }}">
                                    {{ $checklist->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </td>
                            <td>
                                <a href="{{ route('admin.checklists.show', $checklist) }}" class="btn btn-sm btn-outline-info">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <a href="{{ route('admin.checklists.edit', $checklist) }}" class="btn btn-sm btn-outline-primary">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <form action="{{ route('admin.checklists.destroy', $checklist) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger" 
                                            onclick="return confirm('Are you sure?')">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        {{ $checklists->links() }}
    </div>
</div>
@endsection
