@extends('layouts.app')

@section('title', 'My Inspections')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-file-earmark-text"></i> My Inspections</h2>
    <a href="{{ route('worker.inspections.select-checklist') }}" class="btn btn-primary">
        <i class="bi bi-plus"></i> New Inspection
    </a>
</div>

<div class="card">
    <div class="card-body">
        @if($inspections->isEmpty())
            <div class="text-center py-5">
                <i class="bi bi-clipboard-check" style="font-size: 3rem; color: #ccc;"></i>
                <h4 class="mt-3">No Inspections Yet</h4>
                <p class="text-muted">Start your first inspection to see it here.</p>
                <a href="{{ route('worker.inspections.select-checklist') }}" class="btn btn-primary">
                    <i class="bi bi-plus"></i> Start Inspection
                </a>
            </div>
        @else
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Date</th>
                            <th>Equipment</th>
                            <th>Checklist</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($inspections as $inspection)
                            <tr>
                                <td>#{{ $inspection->id }}</td>
                                <td>{{ $inspection->inspection_date->format('M d, Y H:i') }}</td>
                                <td>{{ $inspection->equipment->name }}</td>
                                <td>{{ $inspection->checklist->title }}</td>
                                <td>
                                    <span class="badge bg-{{ $inspection->getStatusClass() }}">
                                        {{ $inspection->getStatusLabel() }}
                                    </span>
                                </td>
                                <td>
                                    <a href="{{ route('worker.inspections.show', $inspection) }}" class="btn btn-sm btn-outline-info">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="{{ route('inspections.print', $inspection) }}" class="btn btn-sm btn-outline-secondary" target="_blank">
                                        <i class="bi bi-printer"></i>
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{ $inspections->links() }}
        @endif
    </div>
</div>
@endsection
